/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.visitor;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Collections;
import java.util.Set;

public interface TypeElementVisitor<C, E>
extends Ordered,
Toggleable {
    default public void visitClass(ClassElement element, VisitorContext context) {
    }

    default public void visitMethod(MethodElement element, VisitorContext context) {
    }

    default public void visitConstructor(ConstructorElement element, VisitorContext context) {
    }

    default public void visitField(FieldElement element, VisitorContext context) {
    }

    default public void visitEnumConstant(EnumConstantElement element, VisitorContext context) {
    }

    default public void start(VisitorContext visitorContext) {
    }

    default public void finish(VisitorContext visitorContext) {
    }

    default public Set<String> getSupportedAnnotationNames() {
        Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(this.getClass(), TypeElementVisitor.class);
        if (classes.length == 2) {
            Class classType = classes[0];
            String classTypeName = classType.getName();
            if (classType == Object.class) {
                classTypeName = this.getClassType();
            }
            if (classTypeName.equals(Object.class.getName())) {
                return Collections.singleton("*");
            }
            Class elementType = classes[1];
            String elementTypeName = elementType.getName();
            if (elementTypeName.equals(Object.class.getName())) {
                elementTypeName = this.getElementType();
            }
            if (elementTypeName.equals(Object.class.getName())) {
                return CollectionUtils.setOf(classTypeName);
            }
            return CollectionUtils.setOf(classTypeName, elementTypeName);
        }
        return Collections.singleton("*");
    }

    default public String getClassType() {
        return Object.class.getName();
    }

    default public String getElementType() {
        return Object.class.getName();
    }

    default public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @NonNull
    default public VisitorKind getVisitorKind() {
        return VisitorKind.AGGREGATING;
    }

    public static enum VisitorKind {
        ISOLATING,
        AGGREGATING;

    }
}

