/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class LeaderAndIsrResponse {
    private final Errors error;
    private final LinkedHashMap<Uuid, List<PartitionError>> topicErrors;

    public LeaderAndIsrResponse(Errors error, LinkedHashMap<Uuid, List<PartitionError>> topicErrors) {
        this.error = error;
        this.topicErrors = topicErrors;
    }

    public LinkedHashMap<Uuid, List<PartitionError>> topics() {
        return this.topicErrors;
    }

    public Errors error() {
        return this.error;
    }

    public Map<Errors, Integer> errorCounts() {
        Errors error = this.error();
        if (error != Errors.NONE) {
            return Collections.singletonMap(error, this.topics().values().stream().mapToInt(partitionErrors -> partitionErrors.size()).sum() + 1);
        }
        Map<Errors, Integer> errors = AbstractResponse.errorCounts(this.topics().values().stream().flatMap(partitionErrors -> partitionErrors.stream()).map(p -> Errors.forCode(p.errorCode)));
        AbstractResponse.updateErrorCounts(errors, Errors.NONE);
        return errors;
    }

    public Map<TopicPartition, Errors> partitionErrors(Map<Uuid, String> topicNames) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        this.topics().forEach((topicId, partitionErrors) -> {
            String topicName = (String)topicNames.get(topicId);
            if (topicName != null) {
                partitionErrors.forEach(partition -> errors.put(new TopicPartition(topicName, partition.partitionIndex), Errors.forCode(partition.errorCode)));
            }
        });
        return errors;
    }

    public String toString() {
        return "LeaderAndIsrResponse{error=" + String.valueOf((Object)this.error) + ", topicErrors=" + String.valueOf(this.topicErrors) + "}";
    }

    public static class PartitionError {
        public final int partitionIndex;
        public final short errorCode;

        public PartitionError(int partitionIndex, short errorCode) {
            this.partitionIndex = partitionIndex;
            this.errorCode = errorCode;
        }
    }
}

