/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.operator;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.runtime.context.RunnerContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionTask {
    protected static final Logger LOG = LoggerFactory.getLogger(ActionTask.class);
    protected final Object key;
    protected final Event event;
    protected final Action action;
    protected transient RunnerContextImpl runnerContext;

    public ActionTask(Object key, Event event, Action action) {
        this.key = key;
        this.event = event;
        this.action = action;
    }

    public RunnerContextImpl getRunnerContext() {
        return this.runnerContext;
    }

    public void setRunnerContext(RunnerContextImpl runnerContext) {
        this.runnerContext = runnerContext;
    }

    public Object getKey() {
        return this.key;
    }

    public abstract ActionTaskResult invoke() throws Exception;

    public class ActionTaskResult {
        private final boolean finished;
        private final List<Event> outputEvents;
        private final Optional<ActionTask> generatedActionTaskOpt;

        public ActionTaskResult(boolean finished, @Nullable List<Event> outputEvents, ActionTask generatedActionTask) {
            this.finished = finished;
            this.outputEvents = outputEvents;
            this.generatedActionTaskOpt = Optional.ofNullable(generatedActionTask);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public List<Event> getOutputEvents() {
            return this.outputEvents;
        }

        public Optional<ActionTask> getGeneratedActionTask() {
            return this.generatedActionTaskOpt;
        }

        public String toString() {
            return "ActionTaskResult{finished=" + this.finished + ", outputEvents=" + String.valueOf(this.outputEvents) + ", generatedActionTaskOpt=" + String.valueOf(this.generatedActionTaskOpt) + "}";
        }
    }
}

