/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;

final class DoublesByteArrayImpl {
    private DoublesByteArrayImpl() {
    }

    static byte[] toByteArray(QuantilesDoublesSketch sketch, boolean ordered, boolean compact) {
        boolean empty = sketch.isEmpty();
        int flags = (empty ? 4 : 0) | (ordered ? 16 : 0) | (compact ? 10 : 0);
        if (empty && !sketch.hasMemorySegment()) {
            byte[] outByteArr = new byte[8];
            MemorySegment segOut = MemorySegment.ofArray(outByteArr);
            boolean preLongs = true;
            DoublesByteArrayImpl.insertPre0(segOut, 1, flags, sketch.getK());
            return outByteArr;
        }
        return DoublesByteArrayImpl.convertToByteArray(sketch, flags, ordered, compact);
    }

    private static byte[] convertToByteArray(QuantilesDoublesSketch sketch, int flags, boolean ordered, boolean compact) {
        int preLongs = sketch.isEmpty() ? 1 : 2;
        int outBytes = compact ? sketch.getCurrentCompactSerializedSizeBytes() : sketch.getCurrentUpdatableSerializedSizeBytes();
        byte[] outByteArr = new byte[outBytes];
        MemorySegment segOut = MemorySegment.ofArray(outByteArr);
        int k = sketch.getK();
        DoublesByteArrayImpl.insertPre0(segOut, preLongs, flags, k);
        if (sketch.isEmpty()) {
            return outByteArr;
        }
        long n = sketch.getN();
        PreambleUtil.insertN(segOut, n);
        PreambleUtil.insertMinDouble(segOut, sketch.isEmpty() ? Double.NaN : sketch.getMinItem());
        PreambleUtil.insertMaxDouble(segOut, sketch.isEmpty() ? Double.NaN : sketch.getMaxItem());
        DoublesSketchAccessor dsa = DoublesSketchAccessor.wrap(sketch, !compact);
        int minAndMax = 2;
        long segOffsetBytes = preLongs + 2 << 3;
        int bbCnt = ClassicUtil.computeBaseBufferItems(k, n);
        if (bbCnt > 0) {
            double[] bbItemsArr = dsa.getArray(0, bbCnt);
            if (ordered) {
                Arrays.sort(bbItemsArr);
            }
            MemorySegment.copy(bbItemsArr, 0, segOut, ValueLayout.JAVA_DOUBLE_UNALIGNED, segOffsetBytes, bbCnt);
        }
        segOffsetBytes += (long)((compact ? bbCnt : 2 * k) << 3);
        int totalLevels = ClassicUtil.computeTotalLevels(sketch.getBitPattern());
        for (int lvl = 0; lvl < totalLevels; ++lvl) {
            dsa.setLevel(lvl);
            if (dsa.numItems() <= 0) continue;
            assert (dsa.numItems() == k);
            MemorySegment.copy(dsa.getArray(0, k), 0, segOut, ValueLayout.JAVA_DOUBLE_UNALIGNED, segOffsetBytes, k);
            segOffsetBytes += (long)(k << 3);
        }
        return outByteArr;
    }

    private static void insertPre0(MemorySegment wseg, int preLongs, int flags, int k) {
        PreambleUtil.insertPreLongs(wseg, preLongs);
        PreambleUtil.insertSerVer(wseg, 3);
        PreambleUtil.insertFamilyID(wseg, Family.QUANTILES.getID());
        PreambleUtil.insertFlags(wseg, flags);
        PreambleUtil.insertK(wseg, k);
    }
}

