/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDoublesSketchSerDeTest {
    @Test
    public void serializeDeserializeEmpty() {
        int N = 20;
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        byte[] bytes = sk1.toByteArray();
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertTrue((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllDoublesSketch sk3 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertTrue((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk3.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        try {
            sk3.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk3.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }

    @Test
    public void serializeDeserializeOneValue() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance();
        sk1.update(1.0);
        byte[] bytes = sk1.toByteArray();
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertFalse((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sk2.getN(), (long)1L);
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)1.0);
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)16);
        KllDoublesSketch sk3 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertFalse((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)1);
        Assert.assertEquals((long)sk3.getN(), (long)1L);
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((double)sk3.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk3.getMaxItem(), (double)1.0);
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }

    @Test
    public void serializeDeserializeMultipleValues() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance();
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sk1.update((double)i);
        }
        Assert.assertEquals((double)sk1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sk1.getMaxItem(), (double)999.0);
        byte[] bytes = sk1.toByteArray();
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertFalse((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((double)sk2.getMinItem(), (double)sk1.getMinItem());
        Assert.assertEquals((double)sk2.getMaxItem(), (double)sk1.getMaxItem());
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllDoublesSketch sk3 = KllDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertFalse((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk3.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((double)sk3.getMinItem(), (double)sk1.getMinItem());
        Assert.assertEquals((double)sk3.getMaxItem(), (double)sk1.getMaxItem());
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }
}

