/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.performance;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class SleepingObjectFactory
implements PooledObjectFactory<Integer> {
    private int counter;
    private boolean debug;

    public void activateObject(PooledObject<Integer> obj) {
        this.debug("activateObject", obj);
        Waiter.sleepQuietly(10L);
    }

    private void debug(String method, Object obj) {
        if (this.debug) {
            String thread = "thread" + Thread.currentThread().getName();
            System.out.println(thread + ": " + method + " " + obj);
        }
    }

    public void destroyObject(PooledObject<Integer> obj) {
        this.debug("destroyObject", obj);
        Waiter.sleepQuietly(250L);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public PooledObject<Integer> makeObject() {
        Integer obj = this.counter++;
        this.debug("makeObject", obj);
        Waiter.sleepQuietly(500L);
        return new DefaultPooledObject((Object)obj);
    }

    public void passivateObject(PooledObject<Integer> obj) {
        this.debug("passivateObject", obj);
        Waiter.sleepQuietly(10L);
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public boolean validateObject(PooledObject<Integer> obj) {
        this.debug("validateObject", obj);
        Waiter.sleepQuietly(30L);
        return true;
    }
}

