/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataFloat;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffRasterDataTest {
    int width = 11;
    int height = 10;
    float[] data;
    AbstractTiffRasterData raster;
    float meanValue;

    public TiffRasterDataTest() {
        double sum = 0.0;
        this.data = new float[this.width * this.height];
        int k = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.data[k] = k;
                sum += (double)k;
                ++k;
            }
        }
        this.raster = new TiffRasterDataFloat(this.width, this.height, this.data);
        this.meanValue = (float)(sum / (double)k);
    }

    @Test
    public void testBadConstructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataFloat(-1, 10), (String)"Constructor did not detect bad width");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataFloat(10, -1), (String)"Constructor did not detect bad height");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataFloat(1, 1, 0), (String)"Constructor did not detect bad samplesPerPixel");
        float[] f = new float[10];
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataFloat(2, 10, f), (String)"Constructor did not detect insufficient input array size");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TiffRasterDataFloat(2, 3, 2, f), (String)"Constructor did not detect insufficient input array size");
    }

    @Test
    public void testBadCoordinates() {
        float[] f = new float[100];
        TiffRasterDataFloat instance = new TiffRasterDataFloat(10, 10, 1, f);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TiffRasterDataTest.lambda$testBadCoordinates$5((AbstractTiffRasterData)instance), (String)"Access method getValue() did not detect bad coordinates");
        Assertions.assertThrows(IllegalArgumentException.class, () -> TiffRasterDataTest.lambda$testBadCoordinates$6((AbstractTiffRasterData)instance), (String)"Access method setValue() did not detect bad coordinates");
        Assertions.assertThrows(IllegalArgumentException.class, () -> TiffRasterDataTest.lambda$testBadCoordinates$7((AbstractTiffRasterData)instance), (String)"Access method setValue() did not detect bad sample index");
    }

    @Test
    public void testGetData() {
        float[] result = this.raster.getData();
        Assertions.assertArrayEquals((float[])this.data, (float[])result);
        int samplesPerPixel = this.raster.getSamplesPerPixel();
        Assertions.assertEquals((int)1, (int)samplesPerPixel, (String)"Incorrect number of samples per pixel");
    }

    @Test
    public void testGetDataType() {
        TiffRasterDataType dataType = this.raster.getDataType();
        Assertions.assertTrue((dataType == TiffRasterDataType.FLOAT ? 1 : 0) != 0, (String)("Unexpected data type " + dataType.name()));
    }

    @Test
    public void testGetHeight() {
        Assertions.assertEquals((int)this.width, (int)this.raster.getWidth(), (String)"Improper height stored");
    }

    @Test
    public void testGetIntData() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + x;
                int test = (int)this.data[index];
                Assertions.assertEquals((int)index, (int)test, (String)("Integer array access test failed at (" + x + "," + y + ")"));
            }
        }
    }

    @Test
    public void testGetSimpleStatistics_0args() {
        TiffRasterStatistics result = this.raster.getSimpleStatistics();
        Assertions.assertEquals((float)0.0f, (float)result.getMinValue(), (String)"Min value failure");
        Assertions.assertEquals((float)(this.width * this.height - 1), (float)result.getMaxValue(), (String)"Max value failure");
        Assertions.assertEquals((float)this.meanValue, (float)result.getMeanValue(), (String)"Mean value failure");
    }

    @Test
    public void testGetSimpleStatistics_float() {
        TiffRasterStatistics result = this.raster.getSimpleStatistics((float)(this.width * this.height - 1));
        Assertions.assertEquals((float)(this.width * this.height - 2), (float)result.getMaxValue(), (String)"Max value failure");
    }

    @Test
    public void testGetValue() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + x;
                int test = (int)this.raster.getValue(x, y);
                Assertions.assertEquals((int)index, (int)test, (String)("Get into source data test failed at (" + x + "," + y + ")"));
                int iTest = this.raster.getIntValue(x, y);
                Assertions.assertEquals((int)index, (int)iTest, (String)("Get into source data test failed at (" + x + "," + y + ")"));
            }
        }
    }

    @Test
    public void testGetValue2() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + x;
                int test = (int)this.raster.getValue(x, y, 0);
                Assertions.assertEquals((int)index, (int)test, (String)("Get into source data test failed at (" + x + "," + y + ")"));
                int iTest = this.raster.getIntValue(x, y, 0);
                Assertions.assertEquals((int)index, (int)iTest, (String)("Get into source data test failed at (" + x + "," + y + ")"));
            }
        }
    }

    @Test
    public void testGetWidth() {
        Assertions.assertEquals((int)this.width, (int)this.raster.getWidth(), (String)"Improper width stored");
    }

    @Test
    public void testSetValue() {
        TiffRasterDataFloat instance = new TiffRasterDataFloat(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + this.height;
                instance.setValue(x, y, (float)index);
                int test = (int)instance.getValue(x, y);
                Assertions.assertEquals((int)index, (int)test, (String)("Set/get value test failed at (" + x + "," + y + ")"));
                instance.setIntValue(x, y, index);
                int iTest = instance.getIntValue(x, y);
                Assertions.assertEquals((int)index, (int)iTest, (String)("Get/set value test failed at (" + x + "," + y + ")"));
            }
        }
    }

    @Test
    public void testSetValue2() {
        TiffRasterDataFloat instance = new TiffRasterDataFloat(this.width, this.height, 2);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = y * this.width + this.height;
                instance.setValue(x, y, 1, (float)index);
                int test = (int)instance.getValue(x, y, 1);
                Assertions.assertEquals((int)index, (int)test, (String)("Set/get value test failed at (" + x + "," + y + ")"));
                instance.setIntValue(x, y, 1, index);
                int iTest = instance.getIntValue(x, y, 1);
                Assertions.assertEquals((int)index, (int)iTest, (String)("Get/set value test failed at (" + x + "," + y + ")"));
            }
        }
    }

    private static /* synthetic */ void lambda$testBadCoordinates$7(AbstractTiffRasterData instance) throws Throwable {
        instance.getValue(1, 1, 2);
    }

    private static /* synthetic */ void lambda$testBadCoordinates$6(AbstractTiffRasterData instance) throws Throwable {
        instance.setValue(11, 11, 5.0f);
    }

    private static /* synthetic */ void lambda$testBadCoordinates$5(AbstractTiffRasterData instance) throws Throwable {
        instance.getValue(11, 11);
    }
}

