/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffJpegTest
extends AbstractTiffTest {
    static final String[] testSet0 = new String[]{"TestSample.tiff", "TestJpegStrips.tiff", "TestJpegTiles.tiff", "TestJpegStripsRgb.tiff", "TestJpegTilesRgb.tiff", "TestJpegCMYK.tiff"};
    static final String[] testSet1 = new String[]{"TestSample264x264.tiff", "TestJpegStrips264x264.tiff", "TestJpegStrips264x264BigEndian.tiff", "TestJpegTiles264x264.tiff", "TestJpegTiles264x264BigEndian.tiff"};
    static final String[] testSet2 = new String[]{"TestSampleArgb.tiff", "TestJpegArgb.tiff"};
    static final String[] testSet3 = new String[]{"TestSampleRgb127x127.tiff", "TestJpegRgb127x127.tiff"};

    private File getTiffFile(String name) {
        File tiffFolder = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, "tiff");
        File tiffJpegFolder = new File(tiffFolder, "14");
        return new File(tiffJpegFolder, name);
    }

    private int gray(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b + 0.5);
    }

    void performSubImageTest(String name) throws IOException {
        File target = this.getTiffFile(name);
        BufferedImage master = Imaging.getBufferedImage((File)target);
        int w = master.getWidth();
        int h = master.getHeight();
        int[] masterArgb = new int[w * h];
        master.getRGB(0, 0, w, h, masterArgb, 0, w);
        TiffImageParser tiffImageParser = new TiffImageParser();
        TiffImagingParameters params = new TiffImagingParameters();
        int testX0 = 11;
        int testY0 = 11;
        int testW = w - 11 - 1;
        int testH = h - 11 - 1;
        params.setSubImage(11, 11, testW, testH);
        BufferedImage test = tiffImageParser.getBufferedImage(target, (ImagingParameters)params);
        int[] testArgb = new int[testW * testH];
        test.getRGB(0, 0, testW, testH, testArgb, 0, testW);
        String label = "Pixel mismatch for " + name;
        for (int i = 0; i < testH; ++i) {
            for (int j = 0; j < testH; ++j) {
                int masterIndex = (i + 11) * w + j + 11;
                int testIndex = i * testW + j;
                int masterPixel = masterArgb[masterIndex];
                int testPixel = testArgb[testIndex];
                Assertions.assertEquals((int)masterPixel, (int)testPixel, (String)label);
            }
        }
    }

    private void processTestSet(String[] testSet) throws IOException {
        File masterFile = this.getTiffFile(testSet[0]);
        BufferedImage masterImage = Imaging.getBufferedImage((File)masterFile);
        int w = masterImage.getWidth();
        int h = masterImage.getHeight();
        int[] masterArgb = new int[w * h];
        masterImage.getRGB(0, 0, w, h, masterArgb, 0, w);
        int[] masterGray = new int[w * h];
        for (int i = 0; i < masterArgb.length; ++i) {
            masterGray[i] = this.gray(masterArgb[i]);
        }
        for (int iFile = 1; iFile < testSet.length; ++iFile) {
            String name = testSet[iFile];
            File f = this.getTiffFile(name);
            BufferedImage test = Imaging.getBufferedImage((File)f);
            int testW = test.getWidth();
            int testH = test.getHeight();
            Assertions.assertEquals((int)w, (int)testW, (String)("Width mismatch for " + name));
            Assertions.assertEquals((int)h, (int)testH, (String)("Height mismatch for " + name));
            String label = "Pixel match for " + name;
            int[] testArgb = new int[w * h];
            test.getRGB(0, 0, w, h, testArgb, 0, w);
            for (int i = 0; i < testArgb.length; ++i) {
                int testGray = this.gray(testArgb[i]);
                int masterA = masterArgb[i] >>> 24;
                int testA = testArgb[i] >>> 24;
                Assertions.assertEquals((float)masterA, (float)testA, (float)1.0f, (String)label);
                Assertions.assertEquals((float)masterGray[i], (float)testGray, (float)4.0f, (String)label);
            }
        }
    }

    @Test
    public void testFullPixelMatch() throws IOException {
        this.processTestSet(testSet0);
        this.processTestSet(testSet1);
        this.processTestSet(testSet2);
        this.processTestSet(testSet3);
    }

    @Test
    public void testSubImage() throws IOException {
        this.performSubImageTest("TestJpegProgressive.tiff");
        this.performSubImageTest("TestJpegTiles264x264.tiff");
        this.performSubImageTest("TestJpegRgb127x127.tiff");
    }
}

