/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.png.AbstractPngTest;
import org.apache.commons.imaging.formats.png.PngImageMetadata;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.test.TestResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngReadTest
extends AbstractPngTest {
    @Test
    public void test() throws Exception {
        Debug.debug((String)"start");
        List<File> images = this.getPngImages();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            if (this.isInvalidPngTestFile(imageFile)) {
                Assertions.assertThrows(Exception.class, () -> Imaging.getMetadata((File)imageFile), (String)"Image read should have failed.");
                Assertions.assertThrows(Exception.class, () -> Imaging.getImageInfo((File)imageFile), (String)"Image read should have failed.");
                Assertions.assertThrows(Exception.class, () -> Imaging.getBufferedImage((File)imageFile), (String)"Image read should have failed.");
                continue;
            }
            ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
            Assertions.assertFalse((boolean)(metadata instanceof File));
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            Assertions.assertNotNull((Object)imageInfo);
            Debug.debug((String)"ICC profile", (Object)Imaging.getIccProfile((File)imageFile));
            BufferedImage image = Imaging.getBufferedImage((File)imageFile);
            Assertions.assertNotNull((Object)image);
        }
    }

    @Test
    public void testReadExif() throws IOException, ImagingException {
        String input = "/images/png/IMAGING-340/image-with-exif.png";
        String file = PngReadTest.class.getResource("/images/png/IMAGING-340/image-with-exif.png").getFile();
        PngImageParser parser = new PngImageParser();
        PngImageMetadata pngMetadata = (PngImageMetadata)parser.getMetadata(new File(file));
        TiffImageMetadata exifMetadata = pngMetadata.getExif();
        Assertions.assertEquals((Object)"Glavo", (Object)exifMetadata.findDirectory(0).getFieldValue((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION));
        PngImageMetadata metadata = (PngImageMetadata)parser.getMetadata(new File(file));
        Assertions.assertTrue((boolean)metadata.getTextualInformation().getItems().isEmpty());
        Assertions.assertEquals((Object)"Glavo", (Object)metadata.getExif().findDirectory(0).getFieldValue((TagInfo)TiffTagConstants.TIFF_TAG_IMAGE_DESCRIPTION));
    }

    @Test
    public void testReadMetadataFromItxtChunk() throws IOException, ImagingException {
        File file = TestResources.resourceToFile("/images/png/IMAGING-342/utf8-comment.png");
        PngImageParser parser = new PngImageParser();
        ImageMetadata metadata = parser.getMetadata(file);
        List items = metadata.getItems();
        Assertions.assertEquals((int)1, (int)items.size());
        GenericImageMetadata.GenericImageMetadataItem item = (GenericImageMetadata.GenericImageMetadataItem)items.get(0);
        Assertions.assertEquals((Object)"Comment", (Object)item.getKeyword());
        Assertions.assertEquals((Object)"\u2192 UTF-8 Test", (Object)item.getText());
    }

    @Test
    public void testUncaughtExceptionOssFuzz33691() throws IOException {
        File file = TestResources.resourceToFile("/images/png/oss-fuzz-33691/clusterfuzz-testcase-minimized-ImagingPngFuzzer-6177282101215232");
        PngImageParser parser = new PngImageParser();
        Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)file), new PngImagingParameters()));
    }

    @Test
    public void testUncaughtExceptionOssFuzz37607() throws IOException {
        File file = TestResources.resourceToFile("/images/png/IMAGING-317/clusterfuzz-testcase-minimized-ImagingPngFuzzer-6242400830357504");
        PngImageParser parser = new PngImageParser();
        Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)file), new PngImagingParameters()));
    }
}

