/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import org.apache.commons.imaging.formats.png.PhysicalScale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PhysicalScaleTest {
    private static final double delta = 0.01;

    @Test
    public void testCreateFromMeters() {
        PhysicalScale physicalScale = PhysicalScale.createFromMeters((double)1.0, (double)2.0);
        Assertions.assertTrue((boolean)physicalScale.isInMeters());
        Assertions.assertFalse((boolean)physicalScale.isInRadians());
        Assertions.assertEquals((double)physicalScale.getHorizontalUnitsPerPixel(), (double)1.0, (double)0.01);
        Assertions.assertEquals((double)physicalScale.getVerticalUnitsPerPixel(), (double)2.0, (double)0.01);
    }

    @Test
    public void testCreateFromRadians() {
        PhysicalScale physicalScale = PhysicalScale.createFromRadians((double)2.0, (double)1.0);
        Assertions.assertFalse((boolean)physicalScale.isInMeters());
        Assertions.assertTrue((boolean)physicalScale.isInRadians());
        Assertions.assertEquals((double)physicalScale.getHorizontalUnitsPerPixel(), (double)2.0, (double)0.01);
        Assertions.assertEquals((double)physicalScale.getVerticalUnitsPerPixel(), (double)1.0, (double)0.01);
    }
}

