/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.psd;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.formats.psd.PsdHeaderInfo;

public class PsdImageContents {
    private static final Logger LOGGER = Logger.getLogger(PsdImageContents.class.getName());
    public final PsdHeaderInfo header;
    public final int colorModeDataLength;
    public final int imageResourcesLength;
    public final int layerAndMaskDataLength;
    public final int compression;

    public PsdImageContents(PsdHeaderInfo header, int colorModeDataLength, int imageResourcesLength, int layerAndMaskDataLength, int compression) {
        this.header = header;
        this.colorModeDataLength = colorModeDataLength;
        this.imageResourcesLength = imageResourcesLength;
        this.layerAndMaskDataLength = layerAndMaskDataLength;
        this.compression = compression;
    }

    public void dump() {
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            this.dump(pw);
            pw.flush();
            sw.flush();
            LOGGER.fine(sw.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void dump(PrintWriter pw) {
        pw.println("");
        pw.println("ImageContents");
        pw.println("Compression: " + this.compression + " (" + Integer.toHexString(this.compression) + ")");
        pw.println("ColorModeDataLength: " + this.colorModeDataLength + " (" + Integer.toHexString(this.colorModeDataLength) + ")");
        pw.println("ImageResourcesLength: " + this.imageResourcesLength + " (" + Integer.toHexString(this.imageResourcesLength) + ")");
        pw.println("LayerAndMaskDataLength: " + this.layerAndMaskDataLength + " (" + Integer.toHexString(this.layerAndMaskDataLength) + ")");
        pw.println("");
        pw.flush();
    }
}

