/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.util.Collections;
import java.util.List;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.png.AbstractPngText;
import org.apache.commons.imaging.formats.png.PhysicalScale;

public class PngImagingParameters
extends XmpImagingParameters<PngImagingParameters> {
    public static final byte DEFAULT_BIT_DEPTH = 8;
    private byte bitDepth = (byte)8;
    private boolean forceIndexedColor;
    private boolean forceTrueColor;
    private boolean predictorEnabled;
    private PhysicalScale physicalScale;
    private List<? extends AbstractPngText> textChunks;

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public PhysicalScale getPhysicalScale() {
        return this.physicalScale;
    }

    public List<? extends AbstractPngText> getTextChunks() {
        return this.textChunks != null ? Collections.unmodifiableList(this.textChunks) : null;
    }

    public boolean isForceIndexedColor() {
        return this.forceIndexedColor;
    }

    public boolean isForceTrueColor() {
        return this.forceTrueColor;
    }

    public boolean isPredictorEnabled() {
        return this.predictorEnabled;
    }

    public PngImagingParameters setBitDepth(byte bitDepth) {
        this.bitDepth = bitDepth;
        return (PngImagingParameters)this.asThis();
    }

    public PngImagingParameters setForceIndexedColor(boolean forceIndexedColor) {
        this.forceIndexedColor = forceIndexedColor;
        return (PngImagingParameters)this.asThis();
    }

    public PngImagingParameters setForceTrueColor(boolean forceTrueColor) {
        this.forceTrueColor = forceTrueColor;
        return (PngImagingParameters)this.asThis();
    }

    public PngImagingParameters setPhysicalScale(PhysicalScale physicalScale) {
        this.physicalScale = physicalScale;
        return (PngImagingParameters)this.asThis();
    }

    public PngImagingParameters setPredictorEnabled(boolean predictorEnabled) {
        this.predictorEnabled = predictorEnabled;
        return (PngImagingParameters)this.asThis();
    }

    public PngImagingParameters setTextChunks(List<? extends AbstractPngText> textChunks) {
        this.textChunks = Collections.unmodifiableList(textChunks);
        return (PngImagingParameters)this.asThis();
    }
}

