/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.util.Formatter;
import java.util.Stack;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryCreateRule
extends Rule {
    private boolean ignoreCreateExceptions;
    private Stack<Boolean> exceptionIgnoredStack;
    protected String attributeName = null;
    protected String className = null;
    protected ObjectCreationFactory<?> creationFactory = null;

    public FactoryCreateRule(String className) {
        this(className, false);
    }

    public FactoryCreateRule(Class<? extends ObjectCreationFactory<?>> clazz) {
        this(clazz, false);
    }

    public FactoryCreateRule(String className, String attributeName) {
        this(className, attributeName, false);
    }

    public FactoryCreateRule(Class<? extends ObjectCreationFactory<?>> clazz, String attributeName) {
        this(clazz, attributeName, false);
    }

    public FactoryCreateRule(ObjectCreationFactory<?> creationFactory) {
        this(creationFactory, false);
    }

    public FactoryCreateRule(String className, boolean ignoreCreateExceptions) {
        this(className, null, ignoreCreateExceptions);
    }

    public FactoryCreateRule(Class<? extends ObjectCreationFactory<?>> clazz, boolean ignoreCreateExceptions) {
        this(clazz, null, ignoreCreateExceptions);
    }

    public FactoryCreateRule(String className, String attributeName, boolean ignoreCreateExceptions) {
        this.className = className;
        this.attributeName = attributeName;
        this.ignoreCreateExceptions = ignoreCreateExceptions;
    }

    public FactoryCreateRule(Class<? extends ObjectCreationFactory<?>> clazz, String attributeName, boolean ignoreCreateExceptions) {
        this(clazz.getName(), attributeName, ignoreCreateExceptions);
    }

    public FactoryCreateRule(ObjectCreationFactory<?> creationFactory, boolean ignoreCreateExceptions) {
        this.creationFactory = creationFactory;
        this.ignoreCreateExceptions = ignoreCreateExceptions;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.ignoreCreateExceptions) {
            if (this.exceptionIgnoredStack == null) {
                this.exceptionIgnoredStack = new Stack();
            }
            try {
                Object instance = this.getFactory(attributes).createObject(attributes);
                if (this.getDigester().getLogger().isDebugEnabled()) {
                    this.getDigester().getLogger().debug(String.format("[FactoryCreateRule]{%s} New %s", this.getDigester().getMatch(), instance == null ? "null object" : instance.getClass().getName()));
                }
                this.getDigester().push(instance);
                this.exceptionIgnoredStack.push(Boolean.FALSE);
            }
            catch (Exception e) {
                if (this.getDigester().getLogger().isInfoEnabled()) {
                    this.getDigester().getLogger().info(String.format("[FactoryCreateRule]{%s} Create exception ignored: %s", this.getDigester().getMatch(), e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
                    if (this.getDigester().getLogger().isDebugEnabled()) {
                        this.getDigester().getLogger().debug("[FactoryCreateRule] Ignored exception:", e);
                    }
                }
                this.exceptionIgnoredStack.push(Boolean.TRUE);
            }
        } else {
            Object instance = this.getFactory(attributes).createObject(attributes);
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug(String.format("[FactoryCreateRule]{%s} New %s", this.getDigester().getMatch(), instance == null ? "null object" : instance.getClass().getName()));
            }
            this.getDigester().push(instance);
        }
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        if (this.ignoreCreateExceptions && this.exceptionIgnoredStack != null && !this.exceptionIgnoredStack.empty() && this.exceptionIgnoredStack.pop().booleanValue()) {
            if (this.getDigester().getLogger().isTraceEnabled()) {
                this.getDigester().getLogger().trace(String.format("[FactoryCreateRule]{%s} No creation so no push so no pop", this.getDigester().getMatch()));
            }
            return;
        }
        Object top = this.getDigester().pop();
        if (this.getDigester().getLogger().isDebugEnabled()) {
            this.getDigester().getLogger().debug(String.format("[FactoryCreateRule]{%s} Pop %s", this.getDigester().getMatch(), top.getClass().getName()));
        }
    }

    @Override
    public void finish() throws Exception {
        if (this.attributeName != null) {
            this.creationFactory = null;
        }
    }

    public String toString() {
        Formatter formatter = new Formatter().format("FactoryCreateRule[className=%s, attributeName=%s", this.className, this.attributeName);
        if (this.creationFactory != null) {
            formatter.format(", creationFactory=%s", this.creationFactory);
        }
        formatter.format("]", new Object[0]);
        return formatter.toString();
    }

    protected ObjectCreationFactory<?> getFactory(Attributes attributes) throws Exception {
        if (this.creationFactory == null) {
            String value;
            String realClassName = this.className;
            if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
                realClassName = value;
            }
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug(String.format("[FactoryCreateRule]{%s} New factory %s", this.getDigester().getMatch(), realClassName));
            }
            Class<?> clazz = this.getDigester().getClassLoader().loadClass(realClassName);
            this.creationFactory = (ObjectCreationFactory)clazz.newInstance();
            this.creationFactory.setDigester(this.getDigester());
        }
        return this.creationFactory;
    }
}

